/*------------------------------------------------------------------------------*
 * File Name: WscriptDlg.c	 													*
 * Creation: Jasmine 09/13/06 #2167												*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Jasmine 09/18/06 FIX_BUTTONS													*
 * Jasmine 09/18/06 DISABLE_IF_NOT_CHECK										*
 * Jasmine 12/11/06 RUN_SCRIPT 													*
 *	Folger 09/27/08 ADD_HELP_FOR_WORKSHEET_SCRIPT_DIALOG						*
 * Jasmine 03/30/09 BOX_FOR_SCRIPT_EDITTING_SHOULD_HAVE_A_CLEAR_FONT			*
 *	CPY 4/17/09 QA70-13474 WKS_SCRIPT_DEFAULT_SHOULD_BE_OGS_STYLE				*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include "DialogEx.h"
#include <o8dlg.h>

class WscriptDlg : public ResizeDialog
{
public:
	WscriptDlg() : ResizeDialog(IDD_WKS_SCRIPT, "ODlg8")
	{
	}
	~WscriptDlg(){}
	int DoModal(HWND hParent = NULL) 
	{
		InitMsgMap();
		int nRet = ResizeDialog::DoModal(hParent);		
		return nRet;
	}	

protected:	
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_SIZE(OnDlgResize)	
	ON_OK(OnDoIt)	
	ON_BN_CLICKED(IDC_WKSC_UPDATE, OnClickUpdate)
	//settings change
	ON_BN_CLICKED(IDC_WKSC_AFTER_IMPORT, 	OnChange)
	ON_BN_CLICKED(IDC_WKSC_AFTER_PASTE, 	OnChange)
	ON_BN_CLICKED(IDC_WKSC_UPON_DATA_CHANGE, OnToggle)//OnChange)///Jasmine 09/18/06 DISABLE_IF_NOT_CHECK
	ON_BN_CLICKED(IDC_WKS_NO_SEMICOLON,		OnChange)
	ON_EN_CHANGE(IDC_WKSC_TEXT, 			OnChange)
	ON_EN_KILLFOCUS(IDC_WKSC_DATA_RANGE, OnContentChange)	
	//ON_HELPINFO(OnHelp)		//------ Folger 09/27/08 ADD_HELP_FOR_WORKSHEET_SCRIPT_DIALOG
EVENTS_END

	//------ Folger 09/27/08 ADD_HELP_FOR_WORKSHEET_SCRIPT_DIALOG
	//BOOL OnHelp(int &nHelpID, int nIdCtrlFocus)
	//{
	   //nHelpID = IDD_WKSCRIPT;
	   //return true;
	//}
	//------ End ADD_HELP_FOR_WORKSHEET_SCRIPT_DIALOG

	BOOL OnInitDialog()
	{
		ResizeDialog::OnInitDialog(IDC_WKSC_TEXT, _L("Worksheet Script"));
		//default
		GetItem(IDC_WKSC_UPDATE).Enable = false;//enable when settings change	
		Button chkNoSemi = GetItem(IDC_WKS_NO_SEMICOLON);
		chkNoSemi.Check = 1;
		Control edRange = GetItem(IDC_WKSC_DATA_RANGE);///Jasmine 09/18/06 DISABLE_IF_NOT_CHECK
		//get script from wks, and init dlg ctrls
		m_wks = Project.ActiveLayer();
		if(!m_wks)
		{
			GetItem(IDOK).Enable = false;
			return error_report("ActiveLayer isn't worksheet!");
		}		
		vector<DWORD> vd = {WKSC_CNTL_IMPORT, WKSC_CNTL_PASTE, WKSC_CNTL_DATA};
 		m_vdCntrls = vd;

		vector<uint> vu = {IDC_WKSC_AFTER_IMPORT, IDC_WKSC_AFTER_PASTE, IDC_WKSC_UPON_DATA_CHANGE, 0};
		m_vuChks = vu;		
		string strScript, strRange;
		DWORD dwCntrl = 0;
		if(m_wks.GetScript(strScript, dwCntrl, strRange))
		{
			GetItem(IDC_WKSC_TEXT).Text = strScript;
			edRange.Text = strRange;//GetItem(IDC_WKSC_DATA_RANGE).Text = strRange;///Jasmine 09/18/06 DISABLE_IF_NOT_CHECK
			for(int ii = 0; m_vuChks[ii] != 0; ii++)
			{
				Button chk = GetItem(m_vuChks[ii]);
				chk.Check = (dwCntrl & m_vdCntrls[ii]);					
			}
			//---- CPY 4/17/09 QA70-13474 WKS_SCRIPT_DEFAULT_SHOULD_BE_OGS_STYLE
			//need to move outside if, so even if not found, VC will decide on dwCntrl value
			//chkNoSemi.Check = !(dwCntrl & WKSC_CNTL_LT_MULTILINES);
			//----
		}
		chkNoSemi.Check = !(dwCntrl & WKSC_CNTL_LT_MULTILINES);//---- CPY 4/17/09 QA70-13474 WKS_SCRIPT_DEFAULT_SHOULD_BE_OGS_STYLE
		
		///Jasmine 09/18/06 DISABLE_IF_NOT_CHECK
		Button chkData = GetItem(IDC_WKSC_UPON_DATA_CHANGE);
		edRange.Enable = chkData.Check;
		///End DISABLE_IF_NOT_CHECK
		
		GetItem(IDC_WKSC_TEXT).SetFont(ANSI_FIXED_FONT);	///Jasmine 03/30/09 BOX_FOR_SCRIPT_EDITTING_SHOULD_HAVE_A_CLEAR_FONT
		
		return TRUE;
	}
	BOOL OnDlgResize(int nType, int cx, int cy)
	{	
		///Jasmine 09/18/06 FIX_BUTTONS
		/*
		uint rightBtnIDs[] = {IDOK, IDC_WKSC_UPDATE, IDCANCEL, 0};
		ArrangeMainItemAndControls(rightBtnIDs, IDC_WKSC_TEXT, NULL, true);//, cx, cy);	
		*/
		///End FIX_BUTTONS
		Control ctrl = GetItem(IDC_WKSC_TEXT);
		RECT rr;
		GetClientRect(ctrl, rr);
		rr.right = cx;
		rr.bottom = cy;	///Jasmine 09/18/06 FIX_BUTTONS
		MoveControl(ctrl,rr);		
		return TRUE;
	}
	BOOL OnDoIt()
	{
		Control ctrl = GetItem(IDC_WKSC_UPDATE);
		if(ctrl.Enable)
			UpdateScript(false);
		//Jasmine 12/11/06 RUN_SCRIPT 
		string strScript = GetItem(IDC_WKSC_TEXT).Text;
		Button chkNoSemi = GetItem(IDC_WKS_NO_SEMICOLON);
		if(chkNoSemi.Check)
		{
			vector<string> vs;
			int nCount = strScript.GetTokens(vs, '\n');
			for(int ii = 0; ii < nCount; ii++)
			{
				vs[ii].TrimRight("\r");
				vs[ii]+=";\r";
			}
			strScript.SetTokens(vs, '\n');
		}
		LT_execute(strScript);
		///End RUN_SCRIPT
		return TRUE;			
	}
	BOOL OnClickUpdate(Control ctrl)
	{
		if(!UpdateScript())
			return FALSE;
		ctrl.Enable = false;		
		GetWindow().SendMessage(WM_CLOSE);//close the dialog
		return TRUE;
	}
	BOOL OnChange(Control ctrl)
	{
		if(!m_wks)
			return error_report("ActiveLayer isn't worksheet!"); 
		GetItem(IDC_WKSC_UPDATE).Enable = true;
		return TRUE;
	}
	///Jasmine 09/18/06 DISABLE_IF_NOT_CHECK
	BOOL OnToggle(Control ctrl)
	{
		Button chk = ctrl;//GetItem(IDC_WKSC_UPON_DATA_CHANGE);
		GetItem(IDC_WKSC_DATA_RANGE).Enable = chk.Check;
		return OnChange(ctrl);
	}
	///End DISABLE_IF_NOT_CHECK
	BOOL OnContentChange(Control ctrl)
	{
		//check if range notation is valid
		return OnChange(ctrl);
	}
	
public:
	bool UpdateScript(bool bShowMsg = true)
	{
		if(!m_wks)
			return false;
		string strScript = GetItem(IDC_WKSC_TEXT).Text;
		string strRange = GetItem(IDC_WKSC_DATA_RANGE).Text;
		DWORD dwCntrl;
		Button chk;
		for(int ii = 0; m_vuChks[ii] != 0; ii++)
		{
			chk = GetItem(m_vuChks[ii]);
			if(chk.Check)
				dwCntrl |= m_vdCntrls[ii];
		}
		Button chkNoSemi = GetItem(IDC_WKS_NO_SEMICOLON);
		if(!chkNoSemi.Check)
			dwCntrl |= WKSC_CNTL_LT_MULTILINES;
		m_wks.SetScript(strScript, dwCntrl, strRange);
		if(bShowMsg)
			MessageBox(GetSafeHwnd(), _L("The Worksheet's script has been updated."), _L("Attention!"), MB_OK);
		return true;
	}
	
private:
	Worksheet 		m_wks;
	vector<DWORD> 	m_vdCntrls;

	vector<uint> 	m_vuChks;
};

bool OpenWscriptDlg()
{
	Worksheet wks = Project.ActiveLayer();
	if(!wks)
		return error_report("ActiveLayer isn't worksheet!"); 
	WscriptDlg WsDlg();
	Window winDlg = WsDlg.GetWindow();
	if(winDlg)
		return error_report("Worksheet Script Dialog already open");
	int nRet = WsDlg.DoModal();
	return true;
}
